/*
 * Copyright (c) 2024 Panasonic Connect Co., Ltd.
 * 2024-06-28 Modified for Cameleo Project.
 */

#ifndef _RTSP_TO_TS_HH
#define _RTSP_TO_TS_HH

#ifndef _BASIC_USAGE_ENVIRONMENT_HH
#include "BasicUsageEnvironment.hh"
#endif

#include <memory>
#include <iostream>

#define UNIQUE_PTR       std::unique_ptr

typedef void (ResultCallbackFunc)(const char *,double);

enum ThreadStatus{
    THREAD_RUNNING = 1,
    THREAD_STOPPED = 0,
    THREAD_ERROR = -1
};


class RtspToTS {
public:
	RtspToTS();
	
	RtspToTS(const char* rtspURL,
			const char* username,
			const char* password,
			unsigned int& outputFileDuration,
			const char* outputFilePath,
			const char* outputFileName,
			unsigned int& maxOutPutFileNum,
			Boolean isOutPutAudio,
			unsigned int& keepAliveInterval);
	
	RtspToTS(const RtspToTS& obj) = delete;
	
	RtspToTS(RtspToTS&& obj) = delete;
	
	~RtspToTS();
	
	RtspToTS& operator=(const RtspToTS& obj) = delete;
	
	RtspToTS& operator=(RtspToTS&& obj) = delete;
	

	Boolean setRtspURL(const char* rtspURL);
	
	Boolean setUserNameAndPassWord(const char* username, const char* password);
	
	Boolean setOutPutFileDuration(unsigned int outputFileDuration);
	
	Boolean setOutPutFilePath(const char* outputFilePath);

	Boolean setOutPutFileName(const char* outputFileName);
	
	Boolean setMaxOutPutFileNum(unsigned int maxOutPutFileNum);
	
	Boolean setIsOutPutAudio(Boolean isOutPutAudio);

	Boolean setKeepAliveInterval(unsigned int keepAliveInterval);
	
	Boolean setResultCallbackFunc(ResultCallbackFunc* callbackFunc);

	Boolean setLogCallbackFunc(LogCallbackFunc* callbackFunc);
	
	const char* getRtspURL();
	
	const char* getUserName();
	
	const char* getPassWord();
	
	unsigned int getOutPutFileDuration();
	
	const char* getOutPutFilePath();

	const char* getOutPutFileName();
	
	unsigned int getMaxOutPutFileNum();
	
	Boolean getIsOutPutAudio();

	unsigned int getKeepAliveInterval();

	// start out put ts files
	Boolean startOutPut();
	
	// stop out put ts files
	Boolean stopOutPut();

	ThreadStatus getThreadStatus();

private:
	class Impl;
	class SegmentRecord;
	UNIQUE_PTR<Impl> pimpl;
	
};

#endif



