/**********
This library is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the
Free Software Foundation; either version 3 of the License, or (at your
option) any later version. (See <http://www.gnu.org/copyleft/lesser.html>.)

This library is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
more details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
**********/
// "liveMedia"
// Copyright (c) 1996-2024 Live Networks, Inc.  All rights reserved.
// Framed Filters
// Implementation

/*
 * Copyright (c) 2024 Panasonic Connect Co., Ltd.
 * 2024-06-28 Modified for Cameleo Project.
 */

#include "FramedFilter.hh"

////////// FramedFilter //////////
#include <string.h>

void FramedFilter::detachInputSource() {
  if (fInputSource != NULL) {
    fInputSource->stopGettingFrames();
    reassignInputSource(NULL);
  }
}

FramedFilter::FramedFilter(UsageEnvironment& env,
			   FramedSource* inputSource)
  : FramedSource(env),
    fInputSource(inputSource) {
}

FramedFilter::~FramedFilter() {
  // It won't work this time and will cause an error. delete it.
  //Medium::close(fInputSource);
}

// Default implementations of needed virtual functions.  These merely
// call the same function in the input source - i.e., act like a 'null filter

char const* FramedFilter::MIMEtype() const {
  if (fInputSource == NULL) return "";

  return fInputSource->MIMEtype();
}

void FramedFilter::getAttributes() const {
  if (fInputSource != NULL) fInputSource->getAttributes();
}

void FramedFilter::doStopGettingFrames() {
  FramedSource::doStopGettingFrames();
  if (fInputSource != NULL) fInputSource->stopGettingFrames();
}
